/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_19;

import java.util.Vector;

import djbuch.kapitel_13.DJAgentContext;
import junit.framework.TestCase;
import lotus.domino.NotesException;

/**
 * @author Thomas Ekert
 *
 */
public class NewsletterTest extends TestCase {

	private static final String RECIPIENT_1 = "thomas@ekert.de";
	private static final String RECIPIENT_2 = "Administrator@www.djbuch.de";
	private static final String INVALID_RECIPIENT = "Nobody_at_home";
	
	
	/**************************************************************************/
	/*****  SETUP  ************************************************************/
	/**************************************************************************/
	private static final boolean debugging = false; //default = false ... true-> mehr Infos anzeigen.
	private static boolean doCleanup = true;		//default = true      false -> kein Aufrumen.
	private static final boolean showTrace = false; //default = false .....true-> vollen Trace fr Meldungen anzeigen.

	/**************************************************************************/
	/**** ab Hier Tests definieren ********************************************/
	/**************************************************************************/

	public void test_01_send() {
		DJLog.info("**********************************************");
		DJLog.info("*** Test 01 - send OK ************************");
		DJLog.info("**********************************************");
		try {
			agentContext = getTestAgentContext();
			Newsletter nl = new Newsletter (agentContext);
			int count = nl.send();
			System.out.println("Anzahl der versendeten NL: "
				+ (count == Newsletter.SEND_ERROR 
					? "FEHLER!" 
					: "" + count));
			assertEquals ("Fehlerhafte Anzahl von erfolgreichen E-Mails", 2, count);
		} catch (NotesException e) {
			DJLog.writeException(e);
			fail ("Unerwartete NotesException");
		}
		DJLog.info("... Test 01 done ...");
	}
	
	public void test_02_sendErrors() {
		DJLog.info("**********************************************");
		DJLog.info("*** Test 02 - send Errors ********************");
		DJLog.info("**********************************************");
		try {
			agentContext = new DJAgentContext ("Anonymous", null, null);
			try {
				Newsletter nl = new Newsletter (agentContext);
				fail ("Exception erwartet.");
			} catch (NotesException expected) {
				assertEquals ("Falsche Fehlernummer", Newsletter.NEWSLETTER_ERROR,expected.id);
			}
			agentContext = new DJAgentContext ("Anonymous",base.getDb(), nlDoc.getDoc());
			try {
				Newsletter nl = new Newsletter (agentContext);
				fail ("Exception erwartet.");
			} catch (NotesException expected) {
				assertEquals ("Falsche Fehlernummer", Newsletter.NEWSLETTER_ERROR,expected.id);
			}
			nlDoc.remove(true);
			nlDoc.recycle();
			nlDoc = NLDocument.getInstance(base.getDb());
			nlDoc.setActive(true);
			nlDoc.setSubject("Test Subject");
			nlDoc.save(true,false);
			agentContext = new DJAgentContext ("Anonymous",base.getDb(), nlDoc.getDoc());
			Newsletter nl = new Newsletter (agentContext);
			assertEquals ("Htte -1 zurckgeben mssen. Versand ohne Body nicht zulssig.",Newsletter.SEND_ERROR,nl.send());
			nlDoc.setBody("Test Inhalt");
			nlDoc.save (true,false);
			assertEquals ("Htte 0 zurckgeben mssen. Kein Recipient.",0,nl.send());
			Vector rec=new Vector();
			rec.add (RECIPIENT_1);
			rec.add (INVALID_RECIPIENT);
			nlDoc.setRecipients(rec);
			nlDoc.save (true,false);
			assertEquals ("Htte -1 zurckgeben mssen. Ungltige E-Mail.",Newsletter.SEND_ERROR,nl.send());
		} catch (NotesException e) {
			DJLog.writeException(e);
			fail("Unerwartete NotesException");
		}
		DJLog.info("... Test 02 done ...");
	}

	/**************************************************************************/
	/**** BIS Hier Tests definieren *******************************************/
	/**************************************************************************/
	
	/**************************************************************************/
	/**** diese Aufrum-Methode muss mit Leben gefllt werden *****************/
	/**************************************************************************/
	private void cleanUp() {
		//do your cleanup Work
		if (nlDoc != null) {
			try {
				nlDoc.remove(true);
			} catch (NotesException e) {
				e.printStackTrace();
			}
		}
	}
	

	/**************************************************************************/
	/**** Hilfs-Methoden ******************************************************/
	/**************************************************************************/
	
	private DJAgentContext getTestAgentContext() throws NotesException {
		nlDoc.setActive(true);
		nlDoc.setBody("Hallo, ich bin ein NL.");
		Vector rec=new Vector();
		rec.add (RECIPIENT_1);
		rec.add (RECIPIENT_2);
		nlDoc.setRecipients(rec);
		nlDoc.setSubject("DJBuch Newsletter");
		nlDoc.save (true,false);
		return new DJAgentContext ("Anonymous",base.getDb(), nlDoc.getDoc());
	}
	
	/**************************************************************************/
	/**** AB HIER NICHTS MEHR NDERN ******************************************/
	/**************************************************************************/

	
	private NotesTestObjects base = null;
	private NLDocument nlDoc = null;
	private DJAgentContext agentContext = null;

	private int logstatus;
	private boolean logtrace;

	public void setUp() throws Exception {
		super.setUp();
		base = new NotesTestObjects();
		nlDoc = NLDocument.getInstance(base.getDb());
		logstatus = DJLog.getLogLevel();
		logtrace = DJLog.getTraceStatus();
		if (debugging) {
			DJLog.setLogLevel(DJLog.DEBUG2);
			DJLog.setTraceStatus(showTrace);
		} else {
			DJLog.setLogLevel(DJLog.INFO);
			DJLog.setTraceStatus(showTrace);
		}
		//weitere Vorbereitung...
	}

	public void tearDown() throws Exception {
		if (doCleanup) {
			cleanUp();
		}
		DJLog.setLogLevel(logstatus);
		DJLog.setTraceStatus(logtrace);
		if (agentContext!=null) {
			agentContext.recycle(); //erledigt implizit das nlDoc.recycle();
		}
		base.recycle();
		super.tearDown();
	}
}
